CREATE DATABASE szinkronhangok;

USE szinkronhangok;

--
-- Tábla szerkezet ehhez a táblához `film`
--

CREATE TABLE `film` (
  `filmaz` int(4) NOT NULL,
  `cim` varchar(70) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `eredeti` varchar(70) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `ev` int(4) NOT NULL,
  `rendezo` varchar(40) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `magyarszoveg` varchar(40) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `szinkronrendezo` varchar(40) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `studio` varchar(40) COLLATE utf8mb4_hungarian_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

--
-- A tábla adatainak kiíratása `film`
--

INSERT INTO `film` (`filmaz`, `cim`, `eredeti`, `ev`, `rendezo`, `magyarszoveg`, `szinkronrendezo`, `studio`) VALUES
(101, 'Batman: A sötét lovag', 'Batman: The Dark Knight', 2008, 'Christopher Nolan', 'Tóth Tamás', 'Tabák Kata', 'Mafilm Audio Kft.'),
(102, 'A Gyűrűk Ura: A király visszatér', 'The Lord of the Rings: Return of the King', 2003, 'Peter Jackson', 'Pataricza Eszter', 'Csörögi István', 'Mafilm Audio Kft.'),
(103, 'A Gyűrűk Ura: A Gyűrű szövetsége', ' The Lord of the Rings: Fellowship of the Ring', 2001, 'Peter Jackson', 'Pataricza Eszter', 'Csörögi István', 'Mafilm Audio Kft.'),
(104, 'A Gyűrűk Ura: A két torony', 'The Lord of the Rings: Two Towers', 2002, 'Peter Jackson', 'Pataricza Eszter', 'Csörögi István', 'Mafilm Audio Kft.'),
(105, 'A zongorista', 'The Pianist', 2002, 'Roman Polanski', 'Pallinger Emőke', 'Orosz Ildikó', 'Masterfilme (Digital) Kft.'),
(106, 'Isten városa', 'Cidade de Deus', 2002, 'Fernando Meirelles', 'Abed Hadi Forát', 'Földi Tamás', 'Active Kommunikációs Kft.'),
(107, 'Gladiátor', 'Gladiator', 2000, 'Ridley Scott', 'Speier Dávid', 'Dóczi Orsolya', 'Balog Mix Stúdió'),
(108, 'A tökéletes trükk', 'The Prestige', 2006, 'Christopher Nolan', 'Szép Erzsébet', 'Rehorovszky Béla', 'Mafilm Audio Kft.'),
(109, 'A tégla', 'The Departed', 2006, 'Martin Scorsese', 'Joó Eszter', 'Báthory Orsolya', 'Mafilm Audio Kft.'),
(110, 'Memento', 'Memento', 2000, 'Christopher Nolan', 'Abed Hadi Forát', 'Nikodém Zsigmond', 'Active Kommunikációs Kft.'),
(111, 'A mások élete', 'Das Leben der Anderen', 2006, 'Florian Henckel von Donnersmarck', 'Simon Nóra', 'Kosztola Tibor', 'Mafilm Audio Kft.'),
(112, 'Becstelen brigantyk', 'Inglourious Basterds', 2009, 'Quentin Tarantino', 'Fuchs Dániel', 'Földi Tamás', 'Active Kommunikációs Kft.'),
(113, 'Batman: Kezdődik!', 'Batman: Begins', 2005, 'Christopher Nolan', 'Joó Eszter', 'Báthory Orsolya', 'Mafilm Audio Kft.'),
(114, 'Egy csodálatos elme', 'A Beautiful Mind', 2001, 'Ron Howard', '', '', ''),
(115, 'A Karib-tenger kalózai - A Fekete Gyöngy átka', 'Pirates of the Caribbean: The Curse of the Black Pearl', 2003, 'Gore Verbinski', 'Heltai Olga', 'Kosztola Tibor', 'Mafilm Audio Kft.'),
(116, 'Eredet', 'Inception', 2010, 'Christopher Nolan', 'Tóth Tamás', 'Tabák Kata', 'Mafilm Audio Kft.'),
(117, 'Csillagok között', 'Interstellar', 2014, 'Christopher Nolan', 'Tóth Tamás', 'Nikodém Zsigmond', 'Mafilm Audio Kft.'),
(118, 'Django elszabadul', 'Django Unchained', 2012, 'Quentin Tarantino', 'Heltai Olga', 'Báthory Orsolya', 'Mafilm Audio Kft.'),
(119, 'Életrevalók', 'Intouchables', 2011, 'Oliver Nakache', 'Molnár Anna', 'Dóczi Orsolya', 'Mafilm Audio Kft.'),
(120, 'A Wall Street farkasa', 'The Wolf of Wall Street', 2013, 'Martin Scorsese', 'Szabadfalvi András', 'Dóczi Orsolya', 'Mafilm Audio Kft.'),
(121, 'Csillagok háborúja I. - Baljós árnyak', 'Star Wars: Episode I - The Phantom Menace', 1999, 'George Lucas', 'Tóth Tamás', 'Csörögi István', 'Mafilm Audio Kft.'),
(122, 'Csillagok háborúja II. - A klónok támadás', 'Star Wars: Episode II - Attack of the Clones', 2002, 'George Lucas', 'Tóth Tamás', 'Csörögi István', 'Mafilm Audio Kft.'),
(123, 'Csillagok háborúja III. - A Sith-ek bosszúja', 'Star Wars: Episode III - Revenge of the Sith', 2005, 'George Lucas', 'Tóth Tamás', 'Csörögi István', 'Mafilm Audio Kft.'),
(124, 'Harry Potter és a Bölcsek Köve', 'Harry Potter and the Sorcerer\'s Stone', 2001, 'Chris Columbus', 'Tóth Tamás', 'Csörögi István', 'Mafilm Audio Kft.'),
(125, 'Harry Potter és a Titkok Kamrája', 'Harry Potter and the Chamber of Secrets', 2002, 'Chris Columbus', 'Tóth Tamás', 'Csörögi István', 'Mafilm Audio Kft.'),
(126, 'Harry Potter és az azkabani fogoly', 'Harry Potter and the Prisoner of Azkaban', 2004, 'Alfonso Cuarón', 'Tóth Tamás', 'Csörögi István', 'Mafilm Audio Kft.'),
(127, 'Csillagok háborúja V. - A Birodalom visszavág', 'Star Wars: Episode V - The Empire Strikes Back', 1980, 'Irvin Kershner', 'Schéry András', 'Dr. Márkus Éva', 'Pannónia Filmstúdió'),
(128, 'A remény rabjai', 'The Shawshank Redemption', 1994, 'Frank Darabont', 'Cser László', 'Szalay Éva', 'Mikroszinkron'),
(129, 'Ponyvaregény', 'Pulp Fiction', 1994, 'Quentin Tarantino', 'Schéry András', 'Juhász Anna', 'Videovox Stúdió Kft.'),
(130, 'Az elveszett frigyláda fosztogatói', 'Raiders of the Lost Ark', 1981, 'Steven Spielberg', 'Schéry András', 'Kosztola Tibor', 'Magyar Szinkron- és Videovállalat'),
(131, 'A cápa I.', 'Jaws I.', 1975, 'Steven Spielberg', 'Soproni Klára', 'Aprics László', 'Magyar Televízió Rt.'),
(132, 'Vissza a jövőbe I.', 'Back to the Future', 1985, 'Robert Zemeckis', 'Sarodi Tibor', 'Kiss Beáta', 'Magyar Szinkron- és Videovállalat'),
(133, 'A nyolcadik utas: a Halál', 'Alien I.', 1979, 'Ridley Scott', 'Gonda Miklós', 'Tomasevics Zorka', 'Syncton Stúdió'),
(134, 'A bolygó neve: Halál', 'Alien II.', 1986, 'James Cameron', 'Schéry András', 'Várkonyi Gyula', 'Magyar Szinkron- és Videovállalat'),
(135, 'Jurassic Park', 'Jurassic Park', 1993, 'Steven Spielberg', 'Lajos Géza', 'Lengyel László', 'Videovox Stúdió Kft.'),
(136, 'Drágán add az életed', 'Die hard', 1988, 'John McTiernan', 'Bari Judit', 'Mauchner József', 'MTA Kutató Filmstúdió'),
(137, 'Mátrix', 'The Matrix', 1999, 'Lilly & Lana Wachowski', 'Görgényi Tamás', 'Báthory Orsolya', 'Mafilm Audio Kft.'),
(138, 'Terminátor - A halálosztó', 'The Terminator', 1984, 'James Cameron', 'Szojka László', 'Kozma Attila', 'Kozmafilm Kft.'),
(139, 'Il buono, il brutto, il cattivo', 'A Jó, a Rossz és a Csúf', 1966, 'Sergio Leone', 'Résch Éva', 'Vas János', 'Pannónia Filmstúdió'),
(140, 'Casablanca', 'Casablanca', 1942, 'Michael Curtiz', 'Nagy Vilma', 'Sipos Varga Éva', 'Magyar Televízió Rt.');

--
-- Tábla szerkezet ehhez a táblához `szinkron`
--

CREATE TABLE `szinkron` (
  `szinkid` int(5) NOT NULL,
  `filmaz` int(4) DEFAULT NULL,
  `szerep` varchar(50) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `szinesz` varchar(50) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `hang` varchar(50) COLLATE utf8mb4_hungarian_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

--
-- A tábla adatainak kiíratása `szinkron`
--

INSERT INTO `szinkron` (`szinkid`, `filmaz`, `szerep`, `szinesz`, `hang`) VALUES
(1001, 101, 'Bruce Wayne (Batman)', 'Christian Bale', 'Fekete Ernő Tibor'),
(1002, 101, 'Joker', 'Heath Ledger', 'Stohl András'),
(1003, 101, 'Harvey Dent (Kétarc)', 'Aaron Eckhart', 'Széles László'),
(1004, 101, 'Alfred Pennyworth', 'Michael Caine', 'Fülöp Zsigmond'),
(1005, 101, 'Rachel Dawes', 'Maggie Gyllenhaal', 'Németh Borbála'),
(1006, 101, 'James Gordon', 'Gary Oldman', 'Epres Attila'),
(1007, 101, 'Lucius Fox', 'Morgan Freeman', 'Reviczky Gábor'),
(1008, 101, 'Anna Ramirez nyomozó', 'Monique Curnen', 'Pap Kati'),
(1009, 101, 'Wuertz nyomozó', 'Ron Dean', 'Orosz István'),
(1010, 101, 'Lau', 'Chin Han', 'Zámbori Soma'),
(1011, 101, 'Anthony Garcia polgármester', 'Nestor Carbonell', 'Király Attila'),
(1012, 101, 'Salvatore Maroni', 'Eric Roberts', 'Kőszegi Ákos'),
(1013, 101, 'Csecsenföldi ember', 'Ritchie Coster', 'Háda János'),
(1014, 101, 'Mike Engel', 'Anthony Michael Hall', 'Juhász György'),
(1015, 101, 'Stephens nyomozó', 'Keith Szarabajka', 'Besenczi Árpád'),
(1016, 101, 'Gillian B. Loeb rendőrfőkapitány', 'Colin McFarlane', 'Jakab Csaba'),
(1017, 102, 'Bruce Wayne (Batman)', 'Christian Bale', 'Fekete Ernő Tibor'),
(1018, 102, 'James Gordon', 'Gary Oldman', 'Epres Attila'),
(1019, 102, 'Bane', 'Tom Hardy', 'László Zsolt'),
(1020, 102, 'Blake', 'Joseph Gordon-Levitt', 'Csőre Gábor'),
(1021, 102, 'Selina', 'Anne Hathaway', 'Bogdányi Titanilla'),
(1022, 102, 'Miranda', 'Marion Cotillard', 'Györgyi Anna'),
(1023, 102, 'Lucius Fox', 'Morgan Freeman', 'Reviczky Gábor'),
(1024, 102, 'Alfred Pennyworth', 'Michael Caine', 'Fülöp Zsigmond'),
(1025, 102, 'Foley', 'Matthew Modine', 'Lux Ádám'),
(1026, 102, 'Dr. Pavel', 'Alon Aboutboul', 'Sipos Imre'),
(1027, 102, 'Daggett', 'Ben Mendelsohn', 'Rajkai Zoltán'),
(1028, 102, 'Stryver', 'Burn Gorman', 'Welker Gábor'),
(1029, 102, 'Jones százados', 'Daniel Sunjata', 'Papp Dániel'),
(1030, 102, 'CIA-ügynök', 'Aidan Gillen', 'Görög László'),
(1031, 102, 'Anthony Garcia polgármester', 'Nestor Carbonell', 'Király Attila'),
(1032, 102, 'Képviselő', 'Brett Cullen', 'Sörös Sándor'),
(1033, 102, 'Reilly atya', 'Chris Ellis', 'Perlaki István'),
(1034, 102, 'Jen', 'Juno Temple', 'Gulás Fanni'),
(1035, 102, 'Orvos', 'Thomas Lennon', 'Dévai Balázs'),
(1036, 102, 'Veterán rendőr', 'Brent Briscoe', 'Bácskai János'),
(1037, 102, 'Vak rab', 'Uri Gavriel', 'Varga Tamás'),
(1038, 102, 'Barsad', 'Josh Stewart', 'Dolmány Attila'),
(1039, 102, 'Amerikai elnök', 'William Devane', 'Várkonyi András'),
(1040, 102, 'Ra\'s al Ghul', 'Liam Neeson', 'Csernák János'),
(1041, 102, 'Dr. Jonathan Crane', 'Cillian Murphy', 'Széles Tamás'),
(1042, 102, 'Rab', 'Tom Conti', 'Körtvélyessy Zsolt'),
(1043, 102, 'Wayne ügyvédje', 'Tomas Arana', 'Tarján Péter'),
(1044, 102, 'Börtönigazgató', 'Wade Williams', 'Törköly Levente'),
(1045, 102, 'Bane zsoldosa', 'Christopher Judge', 'Galambos Péter'),
(1046, 102, 'Thomas Wayne', 'Linus Roache', 'Kálid Artúr'),
(1047, 103, 'Frodó', 'Elijah Wood', 'Csőre Gábor'),
(1048, 103, 'Gandalf', 'Ian McKellen', 'Bács Ferenc'),
(1049, 103, 'Aragorn', 'Viggo Mortensen', 'Selmeczi Roland'),
(1050, 103, 'Samu', 'Sean Astin', 'Kerekes József'),
(1051, 103, 'Trufa', 'Dominic Monaghan', 'Stohl András'),
(1052, 103, 'Pippin', 'Billy Boyd', 'Lippai László'),
(1053, 103, 'Gimli', 'John Rhys-Davies', 'Rajhona Ádám'),
(1054, 103, 'Legolas', 'Orlando Bloom', 'Rékasi Károly'),
(1055, 103, 'Boromir', 'Sean Bean', 'Sinkovits-Vitay András'),
(1056, 103, 'Szarumán', 'Christopher Lee', 'Reviczky Gábor'),
(1057, 103, 'Bilbó', 'Ian Holm', 'Makay Sándor'),
(1058, 103, 'Elrond', 'Hugo Weaving', 'Rosta Sándor'),
(1059, 103, 'Arwen', 'Liv Tyler', 'Solecki Janka'),
(1060, 103, 'Galadriel', 'Cate Blanchett', 'Kovács Nóra'),
(1061, 103, 'Celeborn', 'Marton Csokas', 'Haás Vander Péter'),
(1062, 103, 'Haldír', 'Craig Parker', 'Markovics Tamás'),
(1063, 103, 'Gollam', 'Andy Serkis', 'Láng Balázs'),
(1064, 103, 'Szauron (hangja)', 'Alan Howard', 'Dengyel Iván'),
(1065, 103, 'Papsajt Ászok', 'David Weatherley', 'Szélyes Imre'),
(1066, 103, 'Kapuőr', 'Martyn Sanderson', 'Varga Tamás'),
(1067, 103, 'Lurtz', 'Lawrence Makoare', 'Bolla Róbert'),
(1068, 104, 'Frodó', 'Elijah Wood', 'Csőre Gábor'),
(1069, 104, 'Gandalf', 'Ian McKellen', 'Bács Ferenc'),
(1070, 104, 'Aragorn', 'Viggo Mortensen', 'Selmeczi Roland'),
(1071, 104, 'Samu', 'Sean Astin', 'Kerekes József'),
(1072, 104, 'Trufa', 'Dominic Monaghan', 'Stohl András'),
(1073, 104, 'Pippin', 'Billy Boyd', 'Lippai László'),
(1074, 104, 'Gimli', 'John Rhys-Davies', 'Rajhona Ádám'),
(1075, 104, 'Legolas', 'Orlando Bloom', 'Rékasi Károly'),
(1076, 104, 'Gollam', 'Andy Serkis', 'Láng Balázs'),
(1077, 104, 'Szarumán', 'Christopher Lee', 'Reviczky Gábor'),
(1078, 104, 'Théoden', 'Bernard Hill', 'Ujréti László'),
(1079, 104, 'Éowyn', 'Miranda Otto', 'Györgyi Anna'),
(1080, 104, 'Éomer', 'Karl Urban', 'Viczián Ottó'),
(1081, 104, 'Faramir', 'David Wenham', 'Rajkai Zoltán'),
(1082, 104, 'Kígyónyelvű', 'Brad Dourif', 'Kőszegi Ákos'),
(1083, 104, 'Szilszakáll (hangja)', 'John Rhys-Davies', 'Tolnai Miklós'),
(1084, 104, 'Elrond', 'Hugo Weaving', 'Rosta Sándor'),
(1085, 104, 'Arwen', 'Liv Tyler', 'Solecki Janka'),
(1086, 104, 'Galadriel', 'Cate Blanchett', 'Kovács Nóra'),
(1087, 104, 'Haldír', 'Craig Parker', 'Markovics Tamás'),
(1088, 104, 'Háma', 'John Leigh', 'Csík Csaba Krisztián'),
(1089, 104, 'Gamling', 'Bruce Hopkins', 'Barbinek Péter'),
(1090, 104, 'Madril', 'John Bach', 'Trokán Péter'),
(1091, 104, 'Morwen', 'Robyn Malcolm', 'Spilák Klára'),
(1092, 104, 'Freda', 'Olivia Tennet', 'Bánlaki Kelly'),
(1093, 104, 'Haleth', 'Calum Gittins', 'Kováts Dániel'),
(1094, 104, 'Uglúk', 'Nathaniel Lees', 'Bolla Róbert'),
(1095, 104, 'Mauhur', 'Robbie Magasiva', 'Vass Gábor'),
(1096, 104, 'Grisnák', 'Stephen Ure', 'Rudas István'),
(1097, 104, 'Snaga', 'Jed Brophy', 'Katona Zoltán'),
(1098, 104, 'Sharku', 'Jed Brophy', 'Papucsek Vilmos'),
(1099, 104, 'Damrod', 'Alistair Browning', 'Végh Ferenc'),
(1100, 105, 'Wladyslaw Szpilman', 'Adrien Brody', 'Viczián Ottó'),
(1101, 105, 'Apa', 'Frank Finlay', 'Tolnai Miklós'),
(1102, 105, 'Anya', 'Maureen Lipman', 'Hámori Ildikó'),
(1103, 105, 'Dorota', 'Emilia Fox', 'Ullmann Mónika'),
(1104, 105, 'Henryk', 'Ed Stoppard', 'Rajkai Zoltán'),
(1105, 105, 'Regina', 'Julia Rayner', 'Zakariás Éva'),
(1106, 105, 'Halina', 'Jessica Kate Meyer', 'Szinetár Dóra'),
(1107, 105, 'Dorota férje', 'Valentine Pelka', 'Harmath Imre'),
(1108, 105, 'Szalas', 'Andrew Tiernan', 'Holl Nándor'),
(1109, 105, 'Majorek', 'Daniel Caltagirone', 'Czvetkó Sándor'),
(1110, 105, 'Yehuda', 'Paul Bradley', 'Háda János'),
(1111, 105, 'Beszédet mondó SS-tiszt', 'Peter Rappenglück', 'Várkonyi András'),
(1112, 105, 'Gebczynski', 'Krzysztof Pieczynski', 'Forgács Péter'),
(1113, 105, 'Tollas nő', 'Nomi Sharron', 'Kiss Eszter'),
(1114, 105, 'Átkelésre váró férfi', 'Anthony Milner', 'Pálfai Péter'),
(1115, 105, 'Mr. Grün', 'Cyril Shaps', 'Verebély Iván'),
(1116, 105, 'Munkástárs', 'Lech Mackiewicz', 'Fazekas István'),
(1117, 105, 'Janina', 'Ruth Platt', 'Orosz Anna'),
(1118, 105, 'Dr. Luczak', 'Tom Strauss', 'Gruber Hugó'),
(1119, 105, 'Wilm Hosenfeld százados', 'Thomas Kretschmann', 'Rékasi Károly'),
(1120, 106, 'Rakéta', 'Alexandre Rodrigues', 'Molnár Levente'),
(1121, 106, 'Kis Zé', 'Leandro Firmino', 'Hamvas Dániel'),
(1122, 106, 'Bené', 'Phellipe Haagensen', 'Simonyi Balázs'),
(1123, 106, 'Kis Kocka', 'Douglas Silva', 'Baradlay Viktor'),
(1124, 106, 'Borzas', 'Jonathan Haagensen', 'Kékesi Gábor'),
(1125, 106, 'Répa', 'Matheus Nachtergaele', 'Seszták Szabolcs'),
(1126, 106, 'Csirke', 'Seu Jorge', 'Galambos Péter'),
(1127, 106, 'Nyírógép', 'Jefechander Suplino', 'Előd Botond'),
(1128, 106, 'Angélica', 'Alice Braga', 'Nemes Takách Kata'),
(1129, 106, 'Kis Gyapjas', 'Emerson Gomes', 'Morvay Bence'),
(1130, 106, 'Gyapjas', 'Edson Oliveira', 'Szalay Csongor'),
(1131, 106, 'Berenice', 'Roberta Rodrigues', 'Szénási Kata'),
(1132, 106, 'Kis Rakéta', 'Luis Otávio', 'Szűcs Balázs'),
(1133, 106, 'Rendőrtiszt', 'Maurício Marques', 'Crespo Rodrigo'),
(1134, 106, 'Rogerio Reis', 'Gustavo Engracia', 'Rába Roland'),
(1135, 106, 'Filé', 'Darlan Cunha', 'Morvay Gábor'),
(1136, 106, 'Gerson', 'Robson Rocha', 'Nagy Máté'),
(1137, 106, 'Lampião', 'Thiago Martins', 'Tóth Zoltán Tó'),
(1138, 106, 'Lúcia Maracanã', 'Leandra Miranda', 'Keönch Anna'),
(1139, 106, 'Marina Cintra', 'Graziela Moretto', 'Kiss Virág'),
(1140, 106, 'Bunkó', 'Renato de Souza', 'Borbíró András'),
(1141, 106, 'Tökmag felesége', 'Karina Falcão', 'Solecki Janka'),
(1142, 107, 'Maximus', 'Russell Crowe', 'Vass Gábor'),
(1143, 107, 'Commodus', 'Joaquin Phoenix', 'Rátóti Zoltán'),
(1144, 107, 'Lucilla', 'Connie Nielsen', 'Fullajtár Andrea'),
(1145, 107, 'Proximo', 'Oliver Reed', 'Kránitz Lajos'),
(1146, 107, 'Marcus Aurelius', 'Richard Harris', 'Kristóf Tibor'),
(1147, 107, 'Gracchus', 'Derek Jacobi', 'Fodor Tamás'),
(1148, 107, 'Juba', 'Djimon Hounsou', 'Janovics Sándor'),
(1149, 107, 'Falco', 'David Schofield', 'Sinkovits-Vitay András'),
(1150, 107, 'Gaius', 'John Shrapnel', 'Barbinek Péter'),
(1151, 107, 'Quintus', 'Tomas Arana', 'Rosta Sándor'),
(1152, 107, 'Hagen', 'Ralf Möller', 'F. Nagy Zoltán'),
(1153, 107, 'Lucius', 'Spencer Treat Clark', 'Kováts Dániel'),
(1154, 107, 'Cassius', 'David Hemmings', 'Hollósi Frigyes'),
(1155, 107, 'Cicero', 'Tommy Flanagan', 'Viczián Ottó'),
(1156, 107, 'Tigris', 'Sven-Ole Thorsen', 'Pethes Csaba'),
(1157, 107, 'Rabszolgakereskedő', 'Omid Djalili', 'Sótonyi Gábor'),
(1158, 107, 'Valerius', 'John Quinn', 'Juhász György'),
(1159, 108, 'Robert Angier', 'Hugh Jackman', 'Szabó Sipos Barnabás'),
(1160, 108, 'Alfred Borden', 'Christian Bale', 'Fekete Ernő Tibor'),
(1161, 108, 'Cutter', 'Michael Caine', 'Fülöp Zsigmond'),
(1162, 108, 'Julia McCullough', 'Piper Perabo', 'Csondor Kata'),
(1163, 108, 'Sarah', 'Rebecca Hall', 'Haumann Petra'),
(1164, 108, 'Olivia Wenscombe', 'Scarlett Johansson', 'Ruttkay Laura'),
(1165, 108, 'Tesla', 'David Bowie', 'Sörös Sándor'),
(1166, 108, 'Alley', 'Andy Serkis', 'Kőszegi Ákos'),
(1167, 108, 'Bíró', 'Daniel Davis', 'Orosz István'),
(1168, 108, 'Owens', 'Roger Rees', 'Végh Péter'),
(1169, 108, 'Hoteligazgató', 'Ron Perkins', 'Pálfai Péter'),
(1170, 108, 'Milton', 'Ricky Jay', 'Áron László'),
(1171, 108, 'Merrit', 'William Morgan Sheppard', 'Szersén Gyula'),
(1172, 108, 'Ackerman', 'Edward Hibbert', 'Nagy Gábor'),
(1173, 109, 'Billy', 'Leonardo DiCaprio', 'Hevér Gábor'),
(1174, 109, 'Colin', 'Matt Damon', 'Stohl András'),
(1175, 109, 'Costello', 'Jack Nicholson', 'Reviczky Gábor'),
(1176, 109, 'Dignam', 'Mark Wahlberg', 'Kálloy Molnár Péter'),
(1177, 109, 'Queenan', 'Martin Sheen', 'Papp János'),
(1178, 109, 'Francia', 'Ray Winstone', 'Faragó András'),
(1179, 109, 'Madolyn', 'Vera Farmiga', 'Peller Anna'),
(1180, 109, 'Brown', 'Anthony Anderson', 'Elek Ferenc'),
(1181, 109, 'Ellerby', 'Alec Baldwin', 'Haás Vander Péter'),
(1182, 109, 'Sean, Billy unokatestvére', 'Kevin Corrigan', 'Kardos Róbert'),
(1183, 109, 'Barrigan', 'James Badge Dale', 'Szatmári Attila'),
(1184, 109, 'Fitzy', 'David O\'Hara', 'Zágoni Zsolt'),
(1185, 109, 'Delahunt', 'Mark Rolston', 'Varga Tamás'),
(1186, 109, 'Gwen', 'Kristen Dalton', 'Nyakó Juli'),
(1187, 109, 'Billy nagynénje', 'Mary Klug', 'Illyés Mari'),
(1188, 110, 'Leonard', 'Guy Pearce', 'Széles Tamás'),
(1189, 110, 'Natalie', 'Carrie-Anne Moss', 'Für Anikó'),
(1190, 110, 'Teddy', 'Joe Pantoliano', 'Szombathy Gyula'),
(1191, 110, 'Burt', 'Mark Boone Junior', 'Csuja Imre'),
(1192, 110, 'Sammy', 'Stephen Tobolowsky', 'Konrád Antal'),
(1193, 110, 'Mrs. Jankis', 'Harriet Sansom Harris', 'Zsurzs Kati'),
(1194, 110, 'Dodd', 'Callum Keith Rennie', 'Tóth Roland'),
(1195, 110, 'Jimmy', 'Larry Holden', 'Karácsonyi Zoltán'),
(1196, 110, 'Leonard felesége', 'Jorja Fox', 'Szabó Gertrúd'),
(1197, 110, 'Szőke kurva', 'Kimberly Campbell', 'Pap Kati'),
(1198, 110, 'Pincér', 'Russ Fega', 'Hegedüs Miklós'),
(1199, 110, 'Orvos', 'Thomas Lennon', 'Moser Károly'),
(1200, 110, 'Emma, a tetoválóművész', 'Marianne Muellerleile', 'Téglás Judit'),
(1201, 111, 'Christa-Maria Sieland', 'Martina Gedeck', 'Kováts Adél'),
(1202, 111, 'Gerd Wiesler százados', 'Ulrich Mühe', 'Sörös Sándor'),
(1203, 111, 'Georg Dreyman', 'Sebastian Koch', 'Csernák János'),
(1204, 111, 'Anton Grubitz alezredes', 'Ulrich Tukur', 'Szombathy Gyula'),
(1205, 111, 'Bruno Hempf miniszter', 'Thomas Thieme', 'Ujlaki Dénes'),
(1206, 111, 'Paul Hauser', 'Hans-Uwe Bauer', 'Halmágyi Sándor'),
(1207, 111, 'Albert Jerska', 'Volkmar Kleinert', 'Pálfai Péter'),
(1208, 111, 'Karl Wallner', 'Matthias Brenner', 'Scherer Péter'),
(1209, 111, 'Udo', 'Charly Hübner', 'Hajdu István'),
(1210, 111, 'Gregor Hessenstein', 'Herbert Knaup', 'Juhász György'),
(1211, 112, 'Aldo Raine hadnagy, az Apacs', 'Brad Pitt', 'Varga Gábor'),
(1212, 112, 'Hans Landa SS-ezredes', 'Christoph Waltz', 'Csankó Zoltán'),
(1213, 112, 'Shosanna Dreyfus', 'Mélanie Laurent', 'Pupos Tímea'),
(1214, 112, 'Fredrick Zoller közlegény', 'Daniel Brühl', 'Király Adrián'),
(1215, 112, 'Bridget von Hammersmark', 'Diane Kruger', 'Solecki Janka'),
(1216, 112, 'Archie Hicox hadnagy', 'Michael Fassbender', 'Seder Gábor'),
(1217, 112, 'Hugo Stiglitz őrmester', 'Til Schweiger', 'Stohl András'),
(1218, 112, 'Wilhelm Wicki tizedes', 'Gedeon Burkhard', 'Viczián Ottó'),
(1219, 112, 'Donny Donowitz őrmester, a Medve Zsidó', 'Eli Roth', 'Papp Dániel'),
(1220, 112, 'Omar Ulmer őrvezető', 'Omar Doom', 'Király Adrián'),
(1221, 112, 'Smithson Utivich őrvezető', 'B.J. Novak', 'Szabó Máté'),
(1222, 112, 'Perrier LaPadite', 'Denis Menochet', 'Földi Tamás'),
(1223, 112, 'Dieter Hellstrom őrnagy', 'August Diehl', 'Király Adrián'),
(1224, 112, 'Ed Fenech tábornok', 'Mike Myers', 'Imre István'),
(1225, 112, 'Winston Churchill', 'Rod Taylor', 'Kajtár Róbert'),
(1226, 112, 'Werner Rachtman őrmester', 'Richard Sammel', 'Beratin Gábor'),
(1227, 112, 'Wilhelm törzsőrmester (Pola Negri)', 'Alexander Fehling', 'Magyar Bálint'),
(1228, 113, 'Bruce Wayne (Batman)', 'Christian Bale', 'Fekete Ernő Tibor'),
(1229, 113, 'Alfred Pennyworth', 'Michael Caine', 'Fülöp Zsigmond'),
(1230, 113, 'Henri Ducard', 'Liam Neeson', 'Szakácsi Sándor'),
(1231, 113, 'Rachel Dawes', 'Katie Holmes', 'Zsigmond Tamara'),
(1232, 113, 'Jim Gordon', 'Gary Oldman', 'Kaszás Attila'),
(1233, 113, 'Dr. Jonathan Crane', 'Cillian Murphy', 'Széles Tamás'),
(1234, 113, 'Carmine Falcone', 'Tom Wilkinson', 'Szilágyi Tibor'),
(1235, 113, 'Earle', 'Rutger Hauer', 'Barbinek Péter'),
(1236, 113, 'Ra`s Al Ghul', 'Ken Watanabe', 'Csankó Zoltán'),
(1237, 113, 'Flass', 'Mark Boone Junior', 'Besenczi Árpád'),
(1238, 113, 'Thomas Wayne', 'Linus Roache', 'Selmeczi Roland'),
(1239, 113, 'Lucius Fox', 'Morgan Freeman', 'Kristóf Tibor'),
(1240, 113, 'Finch', 'Larry Holden', 'Sztarenki Pál'),
(1241, 113, 'Faden bíró', 'Gerard Murphy Ge', 'Kardos Gábor'),
(1242, 113, 'Loeb', 'Colin McFarlane', 'Vass Gábor'),
(1243, 113, 'Martha Wayne', 'Sara Stewart', 'Incze Ildikó'),
(1244, 113, 'Bruce Wayne 8 évesen', 'Gus Lewis', 'Morvay Gábor'),
(1245, 113, 'Joe Chill', 'Richard Brake', 'Bicskey Lukács'),
(1246, 113, 'Hajléktalan', 'Rade Serbedzija', 'Reviczky Gábor'),
(1247, 113, 'Rachel Dawes 8 évesen', 'Emma Lockhart', 'Talmács Márta'),
(1248, 113, 'George Fredericks', 'John Nolan', 'Uri István'),
(1249, 113, 'Öreg ázsiai rab', 'Vincent Wong', 'Botár Endre'),
(1250, 113, 'Nagydarab rab', 'Turbo Kong', 'Faragó András'),
(1251, 113, 'Öreg himalájai férfi', 'Tenzin Gyurme', 'Versényi László'),
(1252, 113, 'Wayne Enterprises igazgatósági tag', 'Charles Edwards', 'Juhász György'),
(1253, 113, 'Férfi vendég az étteremben', 'Timothy Deenihan', 'Kapácsy Miklós'),
(1254, 113, 'Vízügyi technikus', 'Shane Rimmer', 'Breyer László'),
(1255, 113, 'Kisfiú az erkélyen', 'Jack Gleeson', 'Czető Ádám'),
(1256, 114, 'John Nash', 'Russell Crowe', 'Rátóti Zoltán'),
(1257, 114, 'Charles', 'Paul Bettany', 'Kaszás Attila'),
(1258, 114, 'Alicia Nash', 'Jennifer Connelly', 'Radó Denise'),
(1259, 114, 'Parcher', 'Ed Harris', 'Rosta Sándor'),
(1260, 114, 'Dr. Rosen', 'Christopher Plummer', 'Rajhona Ádám'),
(1261, 114, 'Hansen', 'Josh Lucas', 'Kautzky Armand'),
(1262, 114, 'Bender', 'Anthony Rapp', 'Lux Ádám'),
(1263, 114, 'Ainsley', 'Jason Gray-Stanford', 'Stohl András'),
(1264, 114, 'Sol', 'Adam Goldberg', 'Bede Fazekas Szabolcs'),
(1265, 114, 'Helinger', 'Judd Hirsch', 'Versényi László'),
(1266, 114, 'Thomas King', 'Austin Pendleton', 'Makay Sándor'),
(1267, 114, 'Tábornok', 'Jesse Doran', 'Áron László'),
(1268, 114, 'Elemző', 'Kent Cassella', 'Katona Zoltán'),
(1269, 115, 'Jack Sparrow kapitány', 'Johnny Depp', 'Király Attila'),
(1270, 115, 'Barbossa kapitány', 'Geoffrey Rush', 'Rajhona Ádám'),
(1271, 115, 'Will Turner', 'Orlando Bloom', 'Csőre Gábor'),
(1272, 115, 'Elizabeth Swann', 'Keira Knightley', 'Szinetár Dóra'),
(1273, 115, 'James Norrington', 'Jack Davenport', 'Sebestyén András'),
(1274, 115, 'Weatherby Swann kormányzó', 'Jonathan Pryce', 'Harsányi Gábor'),
(1275, 115, 'Gillette hadnagy', 'Damian O\'Hare', 'Kardos Róbert'),
(1276, 115, 'Joshamee Gibbs', 'Kevin McNally', 'Faragó András'),
(1277, 115, 'Pintel', 'Lee Arenberg', 'Keresztes Sándor'),
(1278, 115, 'Ragetti', 'Mackenzie Crook', 'Dolmány Attila'),
(1279, 115, 'Marty', 'Martin Klebba', 'Kapácsy Miklós'),
(1280, 115, 'Bo`sun', 'Isaac C. Singleton, Jr.', 'Schneider Zoltán'),
(1281, 115, 'Twigg', 'Michael Berry, Jr.', 'Balázsi Gyula'),
(1282, 115, 'Koehler', 'Treva Etienne', 'Bicskey Lukács'),
(1283, 115, 'Anamaria', 'Zoe Saldana', 'F. Nagy Erika'),
(1284, 115, 'Groves hadnagy', 'Greg Ellis', 'Pálfai Péter'),
(1285, 115, 'Murtogg', 'Giles New', 'Sinkovits-Vitay András'),
(1286, 115, 'Mullroy', 'Angus Barnett', 'Szűcs Sándor'),
(1287, 115, 'Kikötőmester', 'Guy Siner', 'Vizy György'),
(1288, 115, 'Mr. Brown', 'Ralph P. Martin', 'Pethes Csaba'),
(1289, 116, 'Cobb', 'Leonardo DiCaprio', 'Hevér Gábor'),
(1290, 116, 'Saito', 'Ken Watanabe', 'Kőszegi Ákos'),
(1291, 116, 'Mal', 'Marion Cotillard', 'Györgyi Anna'),
(1292, 116, 'Ariadne', 'Ellen Page', 'Bogdányi Titanilla'),
(1293, 116, 'Arthur', 'Joseph Gordon-Levitt', 'Hujber Ferenc'),
(1294, 116, 'Eames', 'Tom Hardy', 'Király Attila'),
(1295, 116, 'Yusuf', 'Dileep Rao', 'Scherer Péter'),
(1296, 116, 'Robert Fischer', 'Cillian Murphy', 'Welker Gábor'),
(1297, 116, 'Peter Browning', 'Tom Berenger', 'Sörös Sándor'),
(1298, 116, 'Maurice Fischer', 'Pete Postlethwaite', 'Forgács Gábor'),
(1299, 116, 'Miles', 'Michael Caine', 'Fülöp Zsigmond'),
(1300, 116, 'Nash', 'Lukas Haas', 'Dévai Balázs'),
(1301, 116, 'Phillipa 5 évesen', 'Taylor Geare', 'Győriványi Laura'),
(1302, 116, 'James 3 évesen', 'Johnathan Geare', 'Straub Norbert'),
(1303, 117, 'Cooper', 'Matthew McConaughey', 'Nagy Ervin'),
(1304, 117, 'Brand', 'Anne Hathaway', 'Horváth Lili'),
(1305, 117, 'Brand professzor', 'Michael Caine', 'Fülöp Zsigmond'),
(1306, 117, 'Murph', 'Jessica Chastain', 'Zsigmond Tamara'),
(1307, 117, 'Murph fiatalon', 'Mackenzie Foy', 'Koller Virág'),
(1308, 117, 'Murph idősen', 'Ellen Burstyn', 'Felföldi Anikó'),
(1309, 117, 'TARS (hangja)', 'Bill Irwin', 'Mertz Tibor'),
(1310, 117, 'CASE (hangja)', 'Josh Stewart', 'Welker Gábor'),
(1311, 117, 'Romilly', 'David Gyasi', 'Fekete Ernő Tibor'),
(1312, 117, 'Doyle', 'Wes Bentley', 'Makranczi Zalán'),
(1313, 117, 'Dr. Mann', 'Matt Damon', 'Stohl András'),
(1314, 117, 'Getty', 'Topher Grace', 'Simon Kornél'),
(1315, 117, 'Tom', 'Casey Affleck', 'Hevér Gábor'),
(1316, 117, 'Tom fiatalon', 'Timothée Chalamet', 'Czető Ádám'),
(1317, 117, 'Donald', 'John Lithgow', 'Konrád Antal'),
(1318, 117, 'Lois', 'Leah Cairns', 'Pálmai Anna'),
(1319, 117, 'Doktor', 'Jeff Hephner', 'Szatmári Attila'),
(1320, 117, 'Ms. Hanley', 'Collette Wolfe', 'Roatis Andrea'),
(1321, 117, 'Igazgató', 'David Oyelowo', 'Király Attila'),
(1322, 117, 'William', 'William Devane', 'Szersén Gyula'),
(1323, 117, 'Adminisztrátor', 'Elyes Gabel', 'Széll Attila'),
(1324, 117, 'Coop', 'Liam Dickinson', 'Zelei Dániel'),
(1325, 118, 'Django', 'Jamie Foxx', 'Kálid Artúr'),
(1326, 118, 'Dr. King Schultz', 'Christoph Waltz', 'Csankó Zoltán'),
(1327, 118, 'Calvin Candie', 'Leonardo DiCaprio', 'Hevér Gábor'),
(1328, 118, 'Broomhilda von Shaft', 'Kerry Washington', 'Bánfalvi Eszter'),
(1329, 118, 'Stephen', 'Samuel L. Jackson', 'Reviczky Gábor'),
(1330, 118, 'Billy Crash', 'Walton Goggins', 'Makranczi Zalán'),
(1331, 118, 'Leonide Moguy', 'Dennis Christopher', 'Gyabronka József'),
(1332, 118, 'Butch Pooch', 'James Remar', 'Kőszegi Ákos'),
(1333, 118, 'Lara Lee Candie-Fitzwilly', 'Laura Cayouette', 'Bertalan Ágnes'),
(1334, 118, 'Mr. Bennett', 'Don Johnson', 'Gáspár Sándor'),
(1335, 118, 'Amerigo Vessepi', 'Franco Nero', 'Szacsvay László'),
(1336, 118, 'Dicky Speck', 'James Russo', 'Papp János'),
(1337, 118, 'Ace Speck', 'James Remar', 'Kőszegi Ákos'),
(1338, 118, 'Gill Tatum rendőrbíró', 'Tom Wopat', 'Ganxsta Zolee'),
(1339, 118, 'Bill Sharp seriff', 'Don Stroud', 'Dengyel Iván'),
(1340, 118, 'Vén Carracun', 'Bruce Dern', 'Borbiczki Ferenc'),
(1341, 118, 'Nagy John Brittle', 'M.C. Gainey', 'Barbinek Péter'),
(1342, 118, 'Kicsi Raj Brittle', 'Cooper Huckabee', 'Tamási Zoltán'),
(1343, 118, 'Gus seriff', 'Lee Horsley', 'Papp János'),
(1344, 118, 'Roy, rabszolgaszállító', 'Michael Parks', 'Bezerédi Zoltán'),
(1345, 118, 'Floyd, rabszolgaszállító', 'John Jarratt', 'Cs. Németh Lajos'),
(1346, 118, 'Jano, rabszolgaszállító', 'Quentin Tarantino', 'Alföldi Róbert'),
(1347, 118, 'Mr. Stonesipher', 'David Steen', 'Nagypál Gábor'),
(1348, 118, 'Betina', 'Miriam F. Glover', 'Papp Lujza'),
(1349, 119, 'Philippe', 'François Cluzet', 'Dunai Tamás'),
(1350, 119, 'Driss', 'Omar Sy', 'Galambos Péter'),
(1351, 119, 'Yvonne', 'Anne Le Ny', 'Igó Éva'),
(1352, 119, 'Magalie', 'Audrey Fleurot', 'Major Melinda'),
(1353, 119, 'Marcelle', 'Clotilde Mollet', 'Ősi Ildikó'),
(1354, 119, 'Albert', 'Christian Ameri', 'Cs. Németh Lajos'),
(1355, 119, 'Antoine', 'Grégoire Oestermann', 'Fazekas István'),
(1356, 119, 'Adama', 'Cyril Mendy', 'Berkes Bence'),
(1357, 119, 'Elisa', 'Alba Gaïa Kraghede Bellugi', 'Csifó Dorina'),
(1358, 119, 'Rendőr', 'Nicky Marbot', 'Thuróczy Szabolcs'),
(1359, 119, 'Ápolójelölt', 'Jean François Cayrey', 'Czvetkó Sándor'),
(1360, 119, 'Ápolójelölt', 'Ian Fenelon', 'Kapácsy Miklós'),
(1361, 119, 'Ápolójelölt', 'François Bureloup', 'Anger Zsolt'),
(1362, 119, 'Ápolójelölt', 'Renaud Barse', 'Makranczi Zalán'),
(1363, 120, 'Jordan Belfort', 'Leonardo DiCaprio', 'Hevér Gábor'),
(1364, 120, 'Donnie Azoff', 'Jonah Hill', 'Elek Ferenc'),
(1365, 120, 'Naomi Lapaglia', 'Margot Robbie', 'Zsigmond Tamara'),
(1366, 120, 'Mark Hanna', 'Matthew McConaughey', 'Nagy Ervin'),
(1367, 120, 'Patrick Denham ügynök', 'Kyle Chandler', 'Kőszegi Ákos'),
(1368, 120, 'Max Belfort', 'Rob Reiner', 'Forgács Gábor'),
(1369, 120, 'Brad', 'Jon Bernthal', 'Király Attila'),
(1370, 120, 'Manny Riskin', 'Jon Favreau', 'Péter Richárd'),
(1371, 120, 'Jean-Jacques Saurel', 'Jean Dujardin', 'Jakab Csaba'),
(1372, 120, 'Emma néni', 'Joanna Lumley', 'Andai Györgyi'),
(1373, 120, 'Teresa Petrillo', 'Cristin Milioti', 'Pálmai Anna'),
(1374, 120, 'Ted Beecham kapitány', 'Shea Whigham', 'Szatory Dávid'),
(1375, 120, 'Chantalle', 'Katarina Cas', 'Bánfalvi Eszter'),
(1376, 120, 'Nicky Koskoff', 'P.J. Byrne', 'Kovács Lehel'),
(1377, 120, 'Chester Ming', 'Kenneth Choi', 'Törköly Levente'),
(1378, 120, 'Robbie Feinberg', 'Brian Sacca', 'Czvetkó Sándor'),
(1379, 120, 'Alden Kupferberg', 'Henry Zebrowski', 'Gyabronka József'),
(1380, 120, 'Toby Welch', 'Ethan Suplee', 'Bolla Róbert'),
(1381, 120, 'Steve Madden', 'Jake Hoffman', 'Szatmári Attila'),
(1382, 120, 'Hildy Azoff', 'Mackenzie Meehan', 'Czirják Csilla'),
(1383, 120, 'Önmaga', 'Bo Dietl', 'Papp János'),
(1384, 120, 'Nicholas', 'Jon Spinogatti', 'Sipos Imre'),
(1385, 120, 'Janet', 'Aya Cash', 'Bogdányi Titanilla'),
(1386, 120, 'Kimmie Belzer', 'Stephanie Kurtzuba', 'Kocsis Mariann'),
(1387, 120, 'Lucas Solomon', 'J.C. MacKenzie', 'Csuha Lajos'),
(1388, 120, 'Rochelle Applebaum', 'Ashlie Atkinson', 'Sági Tímea'),
(1389, 120, 'Csokornyakkendős bróker', 'Thomas Middleditch', 'Szabó Máté'),
(1390, 120, 'Jerry Fogel', 'Stephen Kunken', 'Fazekas István'),
(1391, 120, 'Stratton Oakmont reklámhang (hangja)', 'Edward Herrmann', 'Vass Gábor'),
(1392, 121, 'Obi-Wan Kenobi', 'Ewan McGregor', 'Anger Zsolt'),
(1393, 121, 'Padmé Amidala királynő', 'Natalie Portman', 'Zsigmond Tamara'),
(1394, 121, 'Anakin Skywalker', 'Jake Lloyd', 'Kováts Dániel'),
(1395, 121, 'Qui-Gon Jinn', 'Liam Neeson', 'Kovács István'),
(1396, 121, 'Yoda (hangja)', 'Frank Oz', 'Versényi László'),
(1397, 121, 'Mace Windu', 'Samuel L. Jackson', 'Kőszegi Ákos'),
(1398, 121, 'Palpatine szenátor', 'Ian McDiarmid', 'Gruber Hugó'),
(1399, 121, 'Darth Sidious', 'Ian McDiarmid', 'Melis Gábor'),
(1400, 121, 'Darth Maul', 'Ray Park', 'Zágoni Zsolt'),
(1401, 121, 'Valorum főkancellár', 'Terence Stamp', 'Varga T. József'),
(1402, 121, 'Shmi Skywalker', 'Pernilla August', 'Spilák Klára'),
(1403, 121, 'Watto (hangja)', 'Andrew Secombe', 'Besenczi Árpád'),
(1404, 121, 'Jar Jar Binks (hangja)', 'Ahmed Best', 'Bicskey Lukács'),
(1405, 121, 'C-3PO (hangja)', 'Anthony Daniels', 'Józsa Imre'),
(1406, 121, 'Panaka kapitány', 'Hugh Quarshie', 'Földi Tamás'),
(1407, 121, 'Ric Olié', 'Ralph Brown', 'Cs. Németh Lajos'),
(1408, 121, 'Boss Nass (hangja)', 'Brian Blessed', 'Koroknay Géza'),
(1409, 121, 'Tarpals kapitány', 'Steven Spiers', 'Vizy György'),
(1410, 121, 'Ki-Adi-Mundi', 'Silas Carson', 'Dobránszky Zoltán'),
(1411, 121, 'Sio Bibble kormányzó', 'Oliver Ford Davies', 'Szélyes Imre'),
(1412, 121, 'Mas Amedda', 'Jerome Blake', 'Konrád Antal'),
(1413, 121, 'Nute Gunray helytartó', 'Silas Carson', 'Horányi László'),
(1414, 121, 'Daultay Dofine', 'Chris Sanders', 'Pataki Imre'),
(1415, 121, 'Tey How', 'Amanda Lucas', 'Zsolnai Júlia'),
(1416, 121, 'Beed (hangja)', 'Greg Proops', 'Orosz István'),
(1417, 122, 'Obi-Wan Kenobi', 'Ewan McGregor', 'Anger Zsolt'),
(1418, 122, 'Padmé Amidala szenátornő', 'Natalie Portman', 'Zsigmond Tamara'),
(1419, 122, 'Anakin Skywalker', 'Hayden Christensen', 'Moser Károly'),
(1420, 122, 'Yoda (hangja)', 'Frank Oz', 'Versényi László'),
(1421, 122, 'Mace Windu', 'Samuel L. Jackson', 'Kőszegi Ákos'),
(1422, 122, 'Palpatine főkancellár (Darth Sidious)', 'Ian McDiarmid', 'Gruber Hugó'),
(1423, 122, 'Jango Fett', 'Temuera Morrison', 'Berzsenyi Zoltán'),
(1424, 122, 'Dooku gróf (Darth Tyranus)', 'Christopher Lee', 'Szilágyi Tibor'),
(1425, 122, 'Bail Organa szenátor', 'Jimmy Smits', 'Sörös Sándor'),
(1426, 122, 'Shmi Skywalker-Lars', 'Pernilla August', 'Spilák Klára'),
(1427, 122, 'Watto (hangja)', 'Andrew Secombe', 'Besenczi Árpád'),
(1428, 122, 'Jar Jar Binks (hangja)', 'Ahmed Best', 'Bicskey Lukács'),
(1429, 122, 'C-3PO', 'Anthony Daniels', 'Józsa Imre'),
(1430, 122, 'Typho kapitány', 'Jay Laga\'aia', 'Szabó Sipos Barnabás'),
(1431, 122, 'Cliegg Lars', 'Jack Thompson', 'Szélyes Imre'),
(1432, 122, 'Owen Lars', 'Joel Edgerton', 'Szűcs Sándor'),
(1433, 122, 'Beru Whitesun', 'Bonnie Piesse', 'F. Nagy Erika'),
(1434, 122, 'Ki-Adi-Mundi', 'Silas Carson', 'Dobránszky Zoltán'),
(1435, 122, 'Sio Bibble kormányzó', 'Oliver Ford Davies', 'Szélyes Imre'),
(1436, 122, 'Mas Amedda', 'David Bowers', 'Konrád Antal'),
(1437, 122, 'Nute Gunray helytartó', 'Silas Carson', 'Horányi László'),
(1438, 122, 'Boba Fett', 'Daniel Logan', 'Czető Roland'),
(1439, 122, 'Zam Wesell', 'Leeanna Walsman', 'Ősi Ildikó'),
(1440, 123, 'Obi-Wan Kenobi', 'Ewan McGregor', 'Anger Zsolt'),
(1441, 123, 'Padmé Amidala', 'Natalie Portman', 'Zsigmond Tamara'),
(1442, 123, 'Anakin Skywalker', 'Hayden Christensen', 'Moser Károly'),
(1443, 123, 'Darth Vader (hangja)', 'James Earl Jones', 'Kránitz Lajos'),
(1444, 123, 'Yoda (hangja)', 'Frank Oz', 'Versényi László'),
(1445, 123, 'Mace Windu', 'Samuel L. Jackson', 'Kőszegi Ákos'),
(1446, 123, 'Palpatine főkancellár (Darth Sidious)', 'Ian McDiarmid', 'Gruber Hugó'),
(1447, 123, 'Cody parancsnok', 'Temuera Morrison', 'Berzsenyi Zoltán'),
(1448, 123, 'Dooku gróf (Darth Tyranus)', 'Christopher Lee', 'Szilágyi Tibor'),
(1449, 123, 'Bail Organa szenátor', 'Jimmy Smits', 'Sörös Sándor'),
(1450, 123, 'Grievous tábornok (hangja)', 'Matthew Wood', 'Holl Nándor'),
(1451, 123, 'Jar Jar Binks (hangja)', 'Ahmed Best', 'Bicskey Lukács'),
(1452, 123, 'C-3PO', 'Anthony Daniels', 'Józsa Imre'),
(1453, 123, 'Typho kapitány', 'Jay Laga\'aia', 'Szabó Sipos Barnabás'),
(1454, 123, 'Tion Medon', 'Bruce Spence', 'Kristóf Tibor'),
(1455, 123, 'Ki-Adi-Mundi', 'Silas Carson', 'Dobránszky Zoltán'),
(1456, 123, 'Mas Amedda', 'David Bowers', 'Konrád Antal'),
(1457, 123, 'Nute Gunray', 'Silas Carson', 'Horányi László'),
(1458, 123, 'Antilles kapitány', 'Rohan Nichol', 'Seder Gábor'),
(1459, 124, 'Harry Potter', 'Daniel Radcliffe', 'Gacsal Ádám'),
(1460, 124, 'Ron Weasley', 'Rupert Grint', 'Berkes Bence'),
(1461, 124, 'Hermione Granger', 'Emma Watson', 'Szabó Luca'),
(1462, 124, 'Rubeus Hagrid', 'Robbie Coltrane', 'Hollósi Frigyes'),
(1463, 124, 'Albus Dumbledore', 'Richard Harris', 'Makay Sándor'),
(1464, 124, 'Minerva McGalagony professzor', 'Maggie Smith', 'Kassai Ilona'),
(1465, 124, 'Perselus Piton professzor', 'Alan Rickman', 'Tahi Tóth László'),
(1466, 124, 'Mrs. Molly Weasley', 'Julie Walters', 'Andresz Kati'),
(1467, 124, 'Mr. Ollivander', 'John Hurt', 'Gruber Hugó'),
(1468, 124, 'Félig Fej Nélküli Nick', 'John Cleese', 'Galkó Balázs'),
(1469, 124, 'Lord Voldemort', 'Richard Bremmer', 'Kőszegi Ákos'),
(1470, 124, 'Madame Hooch', 'Zoë Wanamaker', 'Szabó Éva'),
(1471, 124, 'Quirinus Mógus professzor', 'Ian Hart', 'Lippai László'),
(1472, 124, 'Firenze (hangja)', 'Ray Fearon', 'Koncz István'),
(1473, 124, 'Teszlek Süveg (hangja)', 'Leslie Phillips', 'Tardy Balázs'),
(1474, 124, 'Állomásmester', 'Harry Taylor', 'Kardos Gábor'),
(1475, 124, 'Ampók', 'Verne Troyer', 'Katona Zoltán'),
(1476, 125, 'Harry Potter', 'Daniel Radcliffe', 'Gacsal Ádám'),
(1477, 125, 'Ron Weasley', 'Rupert Grint', 'Berkes Bence'),
(1478, 125, 'Hermione Granger', 'Emma Watson', 'Szabó Luca'),
(1479, 125, 'Rubeus Hagrid', 'Robbie Coltrane', 'Hollósi Frigyes'),
(1480, 125, 'Albus Dumbledore', 'Richard Harris', 'Makay Sándor'),
(1481, 125, 'Minerva McGalagony professzor', 'Maggie Smith', 'Kassai Ilona'),
(1482, 125, 'Perselus Piton professzor', 'Alan Rickman', 'Tahi Tóth László'),
(1483, 125, 'Mrs. Molly Weasley', 'Julie Walters', 'Andresz Kati'),
(1484, 125, 'Mr. Arthur Weasley', 'Mark Williams', 'Forgács Gábor'),
(1485, 125, 'Félig Fej Nélküli Nick', 'John Cleese', 'Galkó Balázs'),
(1486, 125, 'Aragog (hangja)', 'Julian Glover', 'Papp János'),
(1487, 125, 'Madame Pomfrey', 'Gemma Jones', 'Tímár Éva'),
(1488, 125, 'Gilderoy Lockhart professzor', 'Kenneth Branagh', 'Csankó Zoltán'),
(1489, 125, 'Pomona Bimba professzor', 'Miriam Margolyes', 'Szabó Éva'),
(1490, 125, 'Teszlek Süveg (hangja)', 'Leslie Phillips', 'Tardy Balázs'),
(1491, 125, 'Állomásmester', 'Harry Taylor', 'Kardos Gábor'),
(1492, 125, 'Dobby, a házi manó (hangja)', 'Toby Jones', 'Cseke Péter'),
(1493, 125, 'Cornelius Caramel', 'Robert Hardy', 'Versényi László'),
(1494, 125, 'Lucius Malfoy', 'Jason Isaacs', 'Szakácsi Sándor'),
(1495, 125, 'Tom Denem', 'Christian Coulson', 'Simonyi Balázs'),
(1496, 125, 'Petunia Dursley néni', 'Fiona Shaw', 'Simon Eszter'),
(1497, 125, 'Vernon Dursley bácsi', 'Richard Griffiths', 'Balázs Péter'),
(1498, 125, 'Dudley Dursley', 'Harry Melling', 'Baráth István'),
(1499, 125, 'Percy Weasley', 'Chris Rankin', 'Petrik Péter'),
(1500, 125, 'Fred Weasley', 'James Phelps', 'Kováts Dániel'),
(1501, 125, 'George Weasley', 'Oliver Phelps', 'Kováts Dániel'),
(1502, 125, 'Ginny Weasley', 'Bonnie Wright', 'Csifó Dorina'),
(1503, 125, 'Argus Frics', 'David Bradley', 'Varga Tamás'),
(1504, 125, 'Filius Flitwick professzor', 'Warwick Davis', 'Szokol Péter'),
(1505, 125, 'Neville Longbottom', 'Matthew Lewis', 'Hám Bertalan'),
(1506, 125, 'Draco Malfoy', 'Tom Felton', 'Borbíró András'),
(1507, 125, 'Vincent Crak', 'Jamie Waylett', 'Előd Botond'),
(1508, 125, 'Gregory Monstro', 'Josh Herdman', 'Bíró Attila'),
(1509, 125, 'Hisztis Mirtyl', 'Shirley Henderson', 'Huszárik Kata'),
(1510, 126, 'Harry Potter', 'Daniel Radcliffe', 'Gacsal Ádám'),
(1511, 126, 'Ron Weasley', 'Rupert Grint', 'Berkes Bence'),
(1512, 126, 'Hermione Granger', 'Emma Watson', 'Szabó Luca'),
(1513, 126, 'Rubeus Hagrid', 'Robbie Coltrane', 'Hollósi Frigyes'),
(1514, 126, 'Albus Dumbledore', 'Michael Gambon', 'Makay Sándor'),
(1515, 126, 'Minerva McGalagony professzor', 'Maggie Smith', 'Kassai Ilona'),
(1516, 126, 'Perselus Piton professzor', 'Alan Rickman', 'Tahi Tóth László'),
(1517, 126, 'Mrs. Lily Potter', 'Geraldine Somerville', 'F. Nagy Erika'),
(1518, 126, 'Mrs. Molly Weasley', 'Julie Walters', 'Andresz Kati'),
(1519, 126, 'Mr. Arthur Weasley', 'Mark Williams', 'Forgács Gábor'),
(1520, 126, 'Sirius Black', 'Gary Oldman', 'Széles Tamás'),
(1521, 126, 'Zanzafej (hangja)', 'Lenny Henry', 'Bácskai János'),
(1522, 126, 'Madame Rosmerta', 'Julie Christie', 'Borbás Gabi'),
(1523, 126, 'Remus Lupin professzor', 'David Thewlis', 'Cs. Németh Lajos'),
(1524, 126, 'Sybil Trelawney professzor', 'Emma Thompson', 'Kovács Nóra'),
(1525, 126, 'Peter Pettigrew (Féregfark)', 'Timothy Spall', 'Tahi József'),
(1526, 126, 'Cornelius Caramel', 'Robert Hardy', 'Versényi László'),
(1527, 126, 'Stan Shunpike', 'Lee Ingleby', 'Hamvas Dániel'),
(1528, 126, 'Marge néni', 'Pam Ferris', 'Győry Franciska'),
(1529, 126, 'Petunia Dursley néni', 'Fiona Shaw', 'Simon Eszter'),
(1530, 126, 'Vernon Dursley bácsi', 'Richard Griffiths', 'Balázs Péter'),
(1531, 126, 'Dudley Dursley', 'Harry Melling', 'Baráth István'),
(1532, 126, 'Percy Weasley', 'Chris Rankin', 'Petrik Péter'),
(1533, 126, 'Fred Weasley', 'James Phelps', 'Kováts Dániel'),
(1534, 126, 'George Weasley', 'Oliver Phelps', 'Kováts Dániel'),
(1535, 126, 'Ginny Weasley', 'Bonnie Wright', 'Csifó Dorina'),
(1536, 126, 'Argus Frics', 'David Bradley', 'Varga Tamás'),
(1537, 126, 'Pansy Parkinson', 'Genevieve Gaunt', 'Garai Dóra'),
(1538, 126, 'Neville Longbottom', 'Matthew Lewis', 'Hám Bertalan'),
(1539, 126, 'Draco Malfoy', 'Tom Felton', 'Borbíró András'),
(1540, 126, 'Vincent Crak', 'Jamie Waylett', 'Előd Botond'),
(1541, 126, 'Gregory Monstro', 'Josh Herdman', 'Bíró Attila'),
(1542, 126, 'Tom, a kocsmáros', 'Jim Tavaré', 'Kajtár Róbert'),
(1543, 126, 'Sir Cadogan', 'Paul Whitehouse', 'Harsányi Gábor'),
(1544, 126, 'Kövér Dáma a festményen', 'Dawn French', 'Náray Erika'),
(1545, 127, 'Luke Skywalker', 'Mark Hamill', 'Szatmári György'),
(1546, 127, 'Han Solo', 'Harrison Ford', 'Téri Sándor'),
(1547, 127, 'Leia Organa hercegnő', 'Carrie Fisher', 'Bencze Ilona'),
(1548, 127, 'Obi-Wan Kenobi', 'Alec Guinness', 'Bács Ferenc'),
(1549, 127, 'C-3PO', 'Anthony Daniels', 'Szatmári István'),
(1550, 127, 'Darth Vader (hangja)', 'James Earl Jones', 'Nagy Attila'),
(1551, 127, 'Lando Calrissian', 'Billy Dee Williams', 'Ujréti László'),
(1552, 127, 'Yoda (hangja)', 'Frank Oz', 'Tyll Attila'),
(1553, 127, 'Palpatine uralkodó', 'Clive Revill', 'Versényi László'),
(1554, 127, 'Carlist Rieekan tábornok', 'Bruce Boa', 'Füzessy Ottó'),
(1555, 127, 'Piett admirális', 'Kenneth Colley', 'Perlaki István'),
(1556, 127, 'Wedge Antilles (Rogue Hármas)', 'Denis Lawson', 'Dobránszky Zoltán'),
(1557, 128, 'Andy Dufresne', 'Tim Robbins', 'Haás Vander Péter'),
(1558, 128, 'Ellis Boyd `Red` Redding', 'Morgan Freeman', 'Papp János'),
(1559, 128, 'Norton igazgató', 'Bob Gunton', 'Végvári Tamás'),
(1560, 128, 'Heywood', 'William Sadler', 'Dörner György'),
(1561, 128, 'Hadley kapitány', 'Clancy Brown', 'Gesztesi Károly'),
(1562, 128, 'Tommy', 'Gil Bellows', 'Bor Zoltán'),
(1563, 128, 'Buddy', 'Mark Rolston', 'Végh Péter'),
(1564, 128, 'Brooks Hatlen', 'James Whitmore', 'Gruber Hugó'),
(1565, 128, 'Kerületi ügyész, 1946', 'Jeffrey DeMunn', 'Kardos Gábor'),
(1566, 128, 'Szúnyog', 'Larry Brandenburg', 'Bácskai János'),
(1567, 128, 'Jigger', 'Neil Giuntoli', 'Holl Nándor'),
(1568, 128, 'Floyd', 'Brian Libby', 'Hankó Attila'),
(1569, 128, 'Snooze', 'David Proval', 'Szűcs Sándor'),
(1570, 128, 'Ernie', 'Joseph Ragno', 'Salinger Gábor'),
(1571, 129, 'Vincent Vega', 'John Travolta', 'Széles László'),
(1572, 129, 'Jules Winnfield', 'Samuel L. Jackson', 'Gáti Oszkár'),
(1573, 129, 'Mia Wallace', 'Uma Thurman', 'Für Anikó'),
(1574, 129, 'Winston Wolfe', 'Harvey Keitel', 'Balázsi Gyula'),
(1575, 129, 'Tökfej (Ringo)', 'Tim Roth', 'Mácsai Pál'),
(1576, 129, 'Nyuszimuszi (Yolanda)', 'Amanda Plummer', 'Vándor Éva'),
(1577, 129, 'Fabienne', 'Maria de Medeiros', 'Györgyi Anna'),
(1578, 129, 'Marsellus Wallace', 'Ving Rhames', 'Kránitz Lajos'),
(1579, 129, 'Lance', 'Eric Stoltz', 'Viczián Ottó'),
(1580, 129, 'Jody', 'Rosanna Arquette', 'Spilák Klára'),
(1581, 129, 'Koons százados', 'Christopher Walken', 'Mihályi Győző'),
(1582, 129, 'Butch Coolidge', 'Bruce Willis', 'Dörner György'),
(1583, 129, 'Paul', 'Paul Calderon', 'Kocsis György'),
(1584, 129, 'Trudy', 'Bronagh Gallagher', 'Náray Erika'),
(1585, 129, 'Zed', 'Peter Greene', 'Szakácsi Sándor'),
(1586, 129, 'A béna', 'Stephen Hibbert', '(nem szó'),
(1587, 129, 'Esmarelda Villa Lobos', 'Angela Jones', 'Tóth Enikő'),
(1588, 129, 'Marvin', 'Phil LaMarr', 'Hevér Gábor'),
(1589, 129, 'Kávézófőnök', 'Robert Ruth', 'Barbinek Péter'),
(1590, 129, 'Raquel', 'Julia Sweeney', 'Náray Erika'),
(1591, 129, 'Jimmie', 'Quentin Tarantino', 'Gesztesi Károly'),
(1592, 129, 'Brett', 'Frank Whaley', 'Stohl András'),
(1593, 129, 'Maynard', 'Duane Whitaker', 'Szabó Sipos Barnabás'),
(1594, 129, 'Roger', 'Burr Steers', 'Bozsó Péter'),
(1595, 129, 'Negyedik srác', 'Alexis Arquette', 'Kálid Artúr'),
(1596, 129, 'Ed Sullivan', 'Jerome Patrick Hoban', 'Háda János'),
(1597, 129, 'Phillip Morris-os törpe', 'Michael Gilden', 'Szokol Péter'),
(1598, 129, 'Nő a balesetnél', 'Kathy Griffin', 'Koffler Gizi'),
(1599, 129, 'Sportriporter (hangja)', 'Rich Turner', 'Koncz István'),
(1600, 130, 'Indiana Jones', 'Harrison Ford', 'Csernák János'),
(1601, 130, 'Marion Ravenwood', 'Karen Allen', 'Vándor Éva'),
(1602, 130, 'Dr. Rene Belloq', 'Paul Freeman', 'Versényi László'),
(1603, 130, 'Toht őrnagy', 'Ronald Lacey Rona', 'Harkányi Endre'),
(1604, 130, 'Sallah', 'John Rhys-Davies', 'Gesztesi Károly'),
(1605, 130, 'Dr. Marcus Brody', 'Denholm Elliott Denh', 'Makay Sándor'),
(1606, 130, 'Dietrich ezredes', 'Wolf Kahler', 'Barbinek Péter'),
(1607, 130, 'Gobler', 'Anthony Higgins', 'Harmath Imre'),
(1608, 130, 'Barranca', 'Vic Tablian', 'Csíkos Gábor '),
(1609, 131, 'Martin Brody rendőrfőnök', 'Roy Scheider', 'Dunai Tamás'),
(1610, 131, 'Quint', 'Robert Shaw', 'Szersén Gyula'),
(1611, 131, 'Matt Hooper', 'Richard Dreyfuss', 'Görög László'),
(1612, 131, 'Ellen Brody', 'Lorraine Gary', 'Kiss Mari'),
(1613, 131, 'Larry Vaughn polgármester', 'Murray Hamilton', 'Dobránszky Zoltán'),
(1614, 131, 'Ben Meadows', 'Carl Gottlieb', 'Maros Gábor'),
(1615, 131, 'Leonard `Lenny` Hendricks rendőrfőnökhelyettes', 'Jeffrey Kramer', 'Malcsiner Péter'),
(1616, 131, 'Christine `Chrissie` Watkins', 'Susan Backlinie', 'Balázs Ági'),
(1617, 131, 'Tom Cassidy', 'Jonathan Filley', 'Nyári Zoltán'),
(1618, 131, 'Mrs. Kintner', 'Lee Fierro', 'Pásztor Erzsi'),
(1619, 131, 'Alex M. Kintner', 'Jeffrey Voorhees', 'Simonyi Balázs'),
(1620, 131, 'Orvosszakértő', 'Robert Nevin', 'Versényi László'),
(1621, 131, 'TV-riporter', 'Peter Benchley', 'Kautzky Armand'),
(1622, 131, 'Mr. Denherder', 'Edward Chalmers, Jr.', 'Láng József'),
(1623, 131, 'Charlie', 'Robert Chambers', 'Melis Gábor'),
(1624, 131, 'Mrs. Taft', 'Fritzi Jane Courtney', 'Kassai Ilona'),
(1625, 132, 'Marty McFly', 'Michael J. Fox', 'Rudolf Péter'),
(1626, 132, 'Dr. Emmett Brown', 'Christopher Lloyd', 'Rajhona Ádám'),
(1627, 132, 'Lorraine Baines McFly', 'Lea Thompson', 'Götz Anna'),
(1628, 132, 'George McFly', 'Crispin Glover', 'Zsótér Sándor'),
(1629, 132, 'Biff Tannen', 'Thomas F. Wilson', 'Sipos András'),
(1630, 132, 'Jennifer Parker', 'Claudia Wells', 'Földesi Judit'),
(1631, 132, 'Mr. Strickland', 'James Tolkan', 'Perlaki István'),
(1632, 132, 'Sam Baines', 'George DiCenzo', 'Máté Gábor'),
(1633, 132, 'Stella Baines', 'Frances Lee McCain', 'Mányai Zsuzsa'),
(1634, 132, 'Dave McFly', 'Marc McClure', 'Szolnoki Tibor'),
(1635, 132, 'Linda McFly', 'Wendie Jo Sperber', 'Balogh Erika'),
(1636, 132, 'Skinhead', 'J.J. Cohen', 'Laklóth Aladár'),
(1637, 132, '3-D', 'Casey Siemaszko', 'Kerekes József'),
(1638, 132, 'Marvin Berry', 'Harry Waters, Jr.', 'Vass Gábor'),
(1639, 132, 'Goldie Wilson', 'Donald Fullilove', 'Felföldi László'),
(1640, 132, 'Babs', 'Lisa Freeman', 'Détár Enikő'),
(1641, 132, 'Betty', 'Cristen Kauffman', 'Farkasinszky Edit'),
(1642, 132, 'Red Thomas', 'George \'Buck\' Flower', 'Kristóf Tibor'),
(1643, 133, 'Dallas', 'Tom Skerritt', 'Harmath Imre'),
(1644, 133, 'Ripley', 'Sigourney Weaver', 'Menszátor Magdolna'),
(1645, 133, 'Lambert', 'Veronica Cartwright', 'Jani Ildikó'),
(1646, 133, 'Brett', 'Harry Dean Stanton', 'Beregi Péter'),
(1647, 133, 'Kane', 'John Hurt', 'Laklóth Aladár'),
(1648, 133, 'Ash', 'Ian Holm', 'Fodor Tamás'),
(1649, 133, 'Parker', 'Yaphet Kotto', 'Varga Tamás'),
(1650, 133, 'Anya (hangja)', 'Helen Horton', 'Debrenti Piroska'),
(1651, 134, 'Ellen Ripley', 'Sigourney Weaver', 'Farkas Zsuzsa'),
(1652, 134, 'Rebecca `Nyuszi` Jorden', 'Carrie Henn', 'Ardai Viktória'),
(1653, 134, 'Dwayne Hicks tizedes', 'Michael Biehn', 'Rátóti Zoltán'),
(1654, 134, 'Bishop', 'Lance Henriksen', 'Tolnai Miklós'),
(1655, 134, 'Carter Burke', 'Paul Reiser', 'Balázsi Gyula'),
(1656, 134, 'Hudson közlegény', 'Bill Paxton', 'Juhász Jácint'),
(1657, 134, 'Gorman hadnagy', 'William Hope', 'Gáti Oszkár'),
(1658, 134, 'Vasquez közlegény', 'Jenette Goldstein', 'Andai Györgyi'),
(1659, 134, 'Apone őrmester', 'Al Matthews', 'Kránitz Lajos'),
(1660, 134, 'Drake közlegény', 'Mark Rolston', 'Dózsa László'),
(1661, 134, 'Frost közlegény', 'Ricco Ross', 'Nagy Gábor'),
(1662, 134, 'Ferro tizedes', 'Colette Hiller', 'Frajt Edit'),
(1663, 134, 'Spunkmeyer közlegény', 'Daniel Kash', 'Konrád Antal'),
(1664, 135, 'Dr. Alan Grant', 'Sam Neill', 'Dörner György'),
(1665, 135, 'Dr. Ellie Sattler', 'Laura Dern', 'Vándor Éva'),
(1666, 135, 'Dr. Ian Malcolm', 'Jeff Goldblum', 'Szabó Sipos Barnabás'),
(1667, 135, 'John Hammond', 'Richard Attenborough', 'Velenczey István'),
(1668, 135, 'Robert Muldoon', 'Bob Peck', 'Gáti Oszkár'),
(1669, 135, 'Donald Gennaro', 'Martin Ferrero', 'Reviczky Gábor'),
(1670, 135, 'Tim Murphy', 'Joseph Mazzello', 'Szőke András'),
(1671, 135, 'Lex Murphy', 'Ariana Richards', 'Vadász Bea'),
(1672, 135, 'Ray Arnold', 'Samuel L. Jackson', 'Jakab Csaba'),
(1673, 135, 'Henry Wu', 'BD Wong', 'Felföldi László'),
(1674, 135, 'Dennis Nedry', 'Wayne Knight', 'Gesztesi Károly'),
(1675, 135, 'Gerry Harding', 'Gerald R. Molen', 'Uri István'),
(1676, 135, 'Juanito Rostagno', 'Miguel Sandoval', 'Kisfalussy Bálint'),
(1677, 135, 'Lewis Dodgson', 'Cameron Thor', 'Forgács Péter'),
(1678, 135, 'Mr. DNS (hangja)', 'Greg Burson', 'Kerekes József'),
(1679, 135, 'Jurassic Park Tour idegenvezetőhang (hangja)', 'Richard Kiley', 'Kardos Gábor'),
(1680, 136, 'John McClane', 'Bruce Willis', 'Vass Gábor'),
(1681, 136, 'Al Powell őrmester', 'Reginald VelJohnson', 'Bata János'),
(1682, 136, 'Holly Gennero McClane', 'Bonnie Bedelia', 'Andresz Kati'),
(1683, 136, 'Karl', 'Alexander Godunov', 'Böröndi Tamás'),
(1684, 136, 'Dwayne T. Robinson helyettes rendőrfőnök', 'Paul Gleason', 'Uri István'),
(1685, 136, 'Richard Thornburg', 'William Atherton', 'Dimulász Miklós'),
(1686, 136, 'Argyle', 'De\'voreaux White', 'Kassai Károly'),
(1687, 136, 'Harry Ellis', 'Hart Bochner', 'Beregi Péter'),
(1688, 136, 'Hans Gruber', 'Alan Rickman', 'Helyey László'),
(1689, 136, 'Theo', 'Clarence Gilyard, Jr.', 'Lesznek Tibor'),
(1690, 136, 'Franco', 'Bruno Doyon', 'Varga Károly'),
(1691, 136, 'Tony', 'Andreas Wisniewski', 'Vogt Károly'),
(1692, 136, 'Joseph Yoshinobu Takagi', 'James Shigeta', 'Perlaki István'),
(1693, 136, 'Johnson különleges FBI-ügynök', 'Robert Davi', 'Szokolay Ottó'),
(1694, 136, 'Johnson FBI-ügynök', 'Grand L. Bush', 'Kalocsay Miklós'),
(1695, 136, 'Mitchell százados', 'Matt Landers', 'Cs. Németh Lajos'),
(1696, 136, 'Marco', 'Lorenzo Caccialanza', 'Kárpáti Tibor'),
(1697, 136, 'Uli', 'Al Leong', 'Botár Endre'),
(1698, 137, 'Neo', 'Keanu Reeves', 'László Zsolt'),
(1699, 137, 'Trinity', 'Carrie-Anne Moss', 'Nagy-Kálózy Eszter'),
(1700, 137, 'Morpheus', 'Laurence Fishburne', 'Gáti Oszkár'),
(1701, 137, 'Smith ügynök', 'Hugo Weaving', 'Rátóti Zoltán'),
(1702, 137, 'Orákulum', 'Gloria Foster', 'Szabó Éva'),
(1703, 137, 'Cypher', 'Joe Pantoliano', 'Epres Attila'),
(1704, 137, 'Tank', 'Marcus Chong', 'Görög László'),
(1705, 137, 'Dozer', 'Anthony Ray Parker', 'Bognár Tamás'),
(1706, 137, 'Mouse', 'Matt Doran', 'Dévai Balázs'),
(1707, 137, 'Switch', 'Belinda McClory', 'Schell Judit'),
(1708, 137, 'Apoc', 'Julian Arahanga', 'Hannus Zoltán'),
(1709, 137, 'Brown ügynök', 'Paul Goddard', 'Rosta Sándor'),
(1710, 137, 'Jones ügynök', 'Robert Taylor', 'Sörös Sándor'),
(1711, 137, 'Choi', 'Marc Aden Gray', 'Rába Roland'),
(1712, 137, 'DuJour', 'Ada Nicodemou', 'Bártfai Andrea'),
(1713, 137, 'Rhineheart', 'David Aston', 'Németh Gábor'),
(1714, 137, 'Papnő', 'Denni Gordon', 'Kocsis Mariann'),
(1715, 137, 'Kanalas srác', 'Rowan Witt', 'Lóránt Balázs'),
(1716, 138, 'A Terminátor', 'Arnold Schwarzenegger', 'Gáti Oszkár'),
(1717, 138, 'Kyle Reese', 'Michael Biehn', 'Haás Vander Péter'),
(1718, 138, 'Sarah Connor', 'Linda Hamilton', 'Fehér Anna'),
(1719, 138, 'Ed Traxler hadnagy', 'Paul Winfield', 'Barbinek Péter'),
(1720, 138, 'Hal Vukovich nyomozó', 'Lance Henriksen', 'Németh Gábor'),
(1721, 138, 'Dr. Peter Silberman', 'Earl Boen', 'Pálfai Péter'),
(1722, 138, 'Ginger Ventura', 'Bess Motta', 'Botos Éva'),
(1723, 138, 'Matt Buchanan', 'Rick Rossovich', 'Seder Gábor'),
(1724, 138, 'Fegyverbolti eladó', 'Dick Miller', 'Végh Ferenc'),
(1725, 138, 'Nancy', 'Shawn Schepps', 'Kerekes Andrea'),
(1726, 139, 'Joe (Szőke)', 'Clint Eastwood', 'Rátóti Zoltán'),
(1727, 139, 'Sentenza (Angyalszem)', 'Lee Van Cleef', 'Gruber Hugó'),
(1728, 139, 'Tuco', 'Eli Wallach', 'Gera Zoltán'),
(1729, 139, 'Alkoholista északi kapitány', 'Aldo Giuffrè', 'Sörös Sándor'),
(1730, 139, 'Pablo Ramirez atya', 'Luigi Pistilli', 'Dobránszky Zoltán'),
(1731, 139, 'Fegyverkereskedő', 'Enzo Petito', 'Képessy József'),
(1732, 139, 'Seriff', 'John Bartha', 'Antal László'),
(1733, 139, 'Szerzetes', 'Angelo Novi', 'Varga T. József'),
(1734, 139, 'Stevens', 'Antonio Casas', 'Fillár István'),
(1735, 139, 'Wallace tizedes', 'Mario Brega', 'Horváth Pál'),
(1736, 139, 'Pardue, a hoteltulajdonos', 'Jesús Guzmán', 'Koroknay Géza'),
(1737, 139, 'Harper százados', 'Antonio Molino Rojo', 'Perlaki István'),
(1738, 140, 'Rick Blaine', 'Humphrey Bogart', 'Kálmán György'),
(1739, 140, 'Ilsa Lund', 'Ingrid Bergman', 'Váradi Hédi'),
(1740, 140, 'Victor Laszlo', 'Paul Henreid', 'Avar István'),
(1741, 140, 'Renault kapitány', 'Claude Rains', 'Agárdy Gábor'),
(1742, 140, 'Strasser őrnagy', 'Conrad Veidt', 'Somogyvári Rudolf'),
(1743, 140, 'Signor Ferrari', 'Sydney Greenstreet', 'Györffy György'),
(1744, 140, 'Ugarte', 'Peter Lorre', 'Harkányi Endre'),
(1745, 140, 'Yvonne', 'Madeleine LeBeau', 'Béres Ilona'),
(1746, 140, 'Sam', 'Dooley Wilson', 'Bessenyei Ferenc'),
(1747, 140, 'Berger', 'John Qualen', 'Perlaki István'),
(1748, 140, 'Sascha', 'Leonid Kinskey', 'Bodrogi Gyula'),
(1749, 140, 'Zsebtolvaj', 'Curt Bois', 'Kabos László'),
(1750, 140, 'Narrátor (hangja)', 'Lou Marcelle', 'Szakáts Miklós'),
(1751, 140, 'Gilbert, krupié', 'Marcel Dalio', 'Zentai Ferenc'),
(1752, 140, 'Jan Brandel', 'Helmut Dantine', 'Fülöp Zsigmond'),
(1753, 140, 'Német bankár, akit Rick nem enged be a kaszinóba', 'Gregory Gaye', 'Kéry Gyula'),
(1754, 140, 'Mrs. Leuchtag, Carl emigráns ismerőse', 'Ilka Grüning', 'Kelemen Éva'),
(1755, 140, 'Tonnelli kapitány', 'Charles La Torre', 'Horkai János'),
(1756, 140, 'Holland bankár a kaszinóban', 'Torben Meyer', 'Velenczey István'),
(1757, 140, 'Francia tiszt, aki inzultálja Yvonne-t', 'Alberto Morin', 'Szabó Ottó'),
(1758, 140, 'Arab árus', 'Frank Puglia', 'Zenthe Ferenc'),
(1759, 140, 'Heinz, Strasser őrnagy szárnysegédje', 'Richard Ryen', 'Farkas Antal'),
(1760, 140, 'Német tiszt Yvonne-nal', 'Hans Heinrich von Twardowski', 'Láng József');

--
-- Indexek a kiírt táblákhoz
--

--
-- A tábla indexei `film`
--
ALTER TABLE `film`
  ADD PRIMARY KEY (`filmaz`);

--
-- A tábla indexei `szinkron`
--
ALTER TABLE `szinkron`
  ADD PRIMARY KEY (`szinkid`),
  ADD KEY `szinkfilm` (`filmaz`);

--
-- Megkötések a kiírt táblákhoz
--

--
-- Megkötések a táblához `szinkron`
--
ALTER TABLE `szinkron`
  ADD CONSTRAINT `szinkfilm` FOREIGN KEY (`filmaz`) REFERENCES `film` (`filmaz`);
COMMIT;

