using System;
using System.Collections.Generic;
using System.Text;


namespace AirNoise.Core
{

    public class Timer
    {

        private enum State
        {
            STOPPED,
            PAUSED,
            TIMING
        };

        private Int32 time = 0;

        private Int32 lastTime = 0;

        private Int32 length = 0;

        private bool loop = false;

        private State state = State.TIMING;


        public void Start()
        {

            state = State.TIMING;
        }

        public void Pause()
        {

            state = State.PAUSED;
        }

        public void Play()
        {

            state = State.TIMING;

        }

        public Int32 Length
        {

            set
            {
                length = value;
            }
            get
            {
                return length;
            }

        }

        public bool Loop
        {

            set
            {
                loop = value;
            }
            get
            {
                return loop;
            }

        }



        public void SetWithPercent(float p)
        {

            time = (Int32)((float)length * p);

        }

        public float Percent 
        {

            get { 
            
                return (float)Seconds / length;
            
            }
        
        }

        public Int32 Seconds
        {

            get
            {

                if (state == State.TIMING)
                {

                    time += (Winmm.timeGetTime() - lastTime);

                    time %= length;

                    lastTime = Winmm.timeGetTime();

                }
                else if (state == State.STOPPED)
                {

                    time = 0;

                }

                return time;

            }
        }
    }
}