using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;


namespace AirNoise.Core
{
    public class Kernel
    {

        private static Renderer renderer = null;

        private static Airplane airPlane = null;

        public static Renderer Renderer
        {
            get
            {
                if (renderer == null)
                {
                    renderer = new Renderer();
                }
                return renderer;
            }
        }



        public static Airplane AirPlane
        {
            get
            {
                return airPlane;
            }
            set {

                airPlane = value;
            
            }
        }

        private static bool IsApplicationIdle()
        {
            User32.MSG msg;
            return !User32.PeekMessage(out msg, IntPtr.Zero, 0, 0, 0);
        }


        public static void MainLoop()
        {
            Renderer.Show();

            while (Renderer.Visible)
            {

                if (IsApplicationIdle() && Renderer.IsActive())
                {
                    Renderer.Invalidate();
                }
                else
                {
                    Application.DoEvents();
                }
            }

        }



    }
}
