using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using AirNoise.Mathlib;
using AirNoise.Core;

namespace AirNoise
{

    public class Airplane
    {
        
        private float intensity = 150;
        private float m = 30;

        private Timer timer = new Timer();

        private Spline sid = new Spline();
        private Vector3 derivatedSID = new Vector3();

        public Spline SID 
        {
            get {

                return sid;
            
            }
        
        }

        public Timer Timer
        {
            get
            {
                return timer;
            }
        }

        public Vector3 Position(float t) {

            derivatedSID = sid.Evaluate(t);

            return derivatedSID;
        }

        public float D(float L) {

            double alfa = 1.5f;
            double mu = 30 / 22;
            //         return (float)Math.Pow(Math.Pow(m * Math.Pow(10, (intensity - L) / 20), 2) - Math.Pow(derivatedSID.z, 2), 0.5);

            double temp1 = Math.Pow(10, (L - intensity + mu * derivatedSID.z) / 20);
            double temp2 = Math.Pow(m, 2) * Math.Pow(temp1, -1 / alfa);
            double temp3 = Math.Pow(derivatedSID.z, 2);
            double temp4 =Math.Sqrt(temp2 - temp3);

            return (float)temp4;
        }

        public float I(float d){

            
            double r = Math.Sqrt(d * d + (double)derivatedSID.z * (double)derivatedSID.z) + m;
            double ret = (double)intensity + 20 * Math.Log10(m / r);

            return (float)ret;

           
        }

        public static Airplane FromFile(string path) 
        {
            Airplane temp = new Airplane();

            StreamReader file = File.OpenText(path);
            string line;
            float lastTime = 0;

            while ((line = file.ReadLine()) != null) {

                string [] p = line.Split(' ');

                lastTime = Convert.ToSingle(p[0]);
                temp.SID.AddKey(lastTime,
                           new Vector3(Convert.ToSingle(p[1]), Convert.ToSingle(p[2]), Convert.ToSingle(p[3])),
                           new Vector3(Convert.ToSingle(p[4]), Convert.ToSingle(p[5]), Convert.ToSingle(p[6])),
                           new Vector3(Convert.ToSingle(p[7]), Convert.ToSingle(p[8]), Convert.ToSingle(p[9])));

            }

            temp.Timer.Length = (int)lastTime;
     
            return temp;
        
        }

    }
}
